clear all

* Set Folder to output one

cd ..\Outputs

* Call dataset of revisions and shocks combined (COMB)

use COMB, clear

gen time=year+(qua-1)/4
egen t=group(year quarter)
tsset t

capture drop MPOa
gen MPOa=MPO
replace MPOa=0 if MPO==. & year>2008

gen dlogY=log(GDPC96/l.GDPC96)*400

*** 5 year moving average
gen dlogY1=(dlogY+l.dlogY+l2.dlogY+l3.dlogY+ ///
			l4.dlogY+l5.dlogY+l6.dlogY+l7.dlogY+ ///
			l8.dlogY+l9.dlogY+l10.dlogY+l11.dlogY+ ///
			l12.dlogY+l13.dlogY+l14.dlogY+l15.dlogY+ ///
			l16.dlogY+l17.dlogY+l18.dlogY+l19.dlogY)/20	
			
replace dlogY=dlogY1

gen hp_dlogY=hpGY20
replace hp_dlogY=(l.hp_dlogY+f.hp_dlogY)/2 if hp_dlogY==. & f.hp_dlogY~=. & l.hp_dlogY~=.

* Dummy variable for the Great Recession

gen DGR=(time==2008 | time==2008.25 | time==2008.5 | time==2008.75 | time==2009 | time==2009.25)
			 
local confidenceval=0.95

if `confidenceval'==1.65 local confidencestr="90%"
if `confidenceval'==0.95 local confidencestr="66%"
			
*===============================================================================
*			       Variables with contemporanous response
*===============================================================================

quiet foreach var in TFP sFP1SPF1 FP2 DE1 OILK OILBH {
	
	noisily di "====================================================="
	noisily di "			`var'"
	noisily di "====================================================="
	
	* Define strings for titles of IRF figures
	
	if "`var'"=="TFP" local var_str="TFP shock (Fernald)"
	if "`var'"=="sFP1SPF1" local var_str="Gov't spending shock (AG 2012)"
	if "`var'"=="DE1" local var_str="Military spending shock (Ramey 2016)"
	if "`var'"=="DE2" local var_str="Military spending shock (Ramey 2016)"
	if "`var'"=="OIL" local var_str="Oil supply shock (Kilian 2004)"
	if "`var'"=="OILK" local var_str="Oil supply shock (Kilian 2009)"
	if "`var'"=="OILBH" local var_str="Oil supply shock (Baumeister and Hamilton 2015)"
	if "`var'"=="FP2" local var_str="Tax shock (Romer and Romer 2010)"
	
	capture drop Z*
	gen Z=`var'
	sum Z
	replace Z=Z/r(sd)
	
	*Create current and lagged values of the shock
	
	forvalues i=0(1)8 {
		gen Z`i'=l`i'.Z
	}
	
	reg GREgRpot0 maGY20 Z?
	capture drop smpl0
	gen smpl0=e(sample)
	drop Z
	
	capture drop irf*
	*** time for IRFs
	gen irf_0=t-1
	
	*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	*				          IRF for potential output
	*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	
	newey GREgRpot0 Z* D911 DGR if smpl0==1, lag(4)
	
	gen irf_pot_m=.
	gen irf_pot_se=.
	local str0="Z0"
	lincom "`str0'"
	replace irf_pot_m=r(estimate) if irf_0==0
	replace irf_pot_se=r(se) if irf_0==0
		
	forvalues i=1(1)8 {
		local str0="`str0'" + "+Z`i'" 
		lincom "`str0'"
		replace irf_pot_m=r(estimate) if irf_0==`i'
		replace irf_pot_se=r(se) if irf_0==`i'
	}	
	
	gen irf_pot_m_up=irf_pot_m+`confidenceval'*irf_pot_se
	gen irf_pot_m_lo=irf_pot_m-`confidenceval'*irf_pot_se
	
	*** test cumulative sum for the potential is zero
	lincom Z0+Z1+Z2+Z3+Z4+Z5+Z6+Z7+Z8
	local pval_pot_irf=strofreal((1-normal(abs(r(estimate)/r(se))))*2,"%4.3f") 
	
	*** test pointwise that the potential output IRF (growth rate) is zero for the growth rate
	test Z0 Z1 Z2 Z3 Z4 Z5 Z6 Z7 Z8
	local pval_pot_irf_point=strofreal(r(p),"%4.3f") 

	*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	*				         IRF for actual output
	*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	
	newey maGY20 Z* D911 DGR if smpl0==1, lag(4)

	gen irf_act_m=.
	gen irf_act_se=.	
	local str0="Z0"
	lincom "`str0'"
	replace irf_act_m=r(estimate) if irf_0==0
	replace irf_act_se=r(se) if irf_0==0
		
	forvalues i=1(1)8 {
		local str0="`str0'" + "+Z`i'" 
		lincom "`str0'"
		replace irf_act_m=r(estimate) if irf_0==`i'
		replace irf_act_se=r(se) if irf_0==`i'
	}		
		
	gen irf_act_m_up=irf_act_m+`confidenceval'*irf_act_se
	gen irf_act_m_lo=irf_act_m-`confidenceval'*irf_act_se		

	*** test cumulative sum for the actual is zero	
	lincom Z0+Z1+Z2+Z3+Z4+Z5+Z6+Z7+Z8
	local pval_act_irf=strofreal((1-normal(abs(r(estimate)/r(se))))*2,"%4.3f")
	*** test pointwise that the actual output IRF (growth rate) is zero for the growth rate
	test Z0 Z1 Z2 Z3 Z4 Z5 Z6 Z7 Z8
	local pval_act_irf_point=strofreal(r(p),"%4.3f") 

	*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	*				    IRF for HP filtered actual output
	*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	
	newey hp_dlogY Z* D911 DGR if smpl0==1, lag(4)

	gen irf_hp_m=.
	gen irf_hp_se=.	
	local str0="Z0"
	lincom "`str0'"
	replace irf_hp_m=r(estimate) if irf_0==0
	replace irf_hp_se=r(se) if irf_0==0
		
	forvalues i=1(1)8 {
		local str0="`str0'" + "+Z`i'" 
		lincom "`str0'"
		replace irf_hp_m=r(estimate) if irf_0==`i'
		replace irf_hp_se=r(se) if irf_0==`i'
	}		
		
	gen irf_hp_m_up=irf_hp_m+`confidenceval'*irf_hp_se
	gen irf_hp_m_lo=irf_hp_m-`confidenceval'*irf_hp_se		

	*** test cumulative sum for the actual is zero	
	lincom Z0+Z1+Z2+Z3+Z4+Z5+Z6+Z7+Z8
	local pval_hp_irf=strofreal((1-normal(abs(r(estimate)/r(se))))*2,"%4.3f")
	*** test pointwise that the actual output IRF (growth rate) is zero for the growth rate
	test Z0 Z1 Z2 Z3 Z4 Z5 Z6 Z7 Z8
	local pval_hp_irf_point=strofreal(r(p),"%4.3f") 
	
	*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	*				     IRF for actual output - potential
	*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	
	capture drop D_actual_minus_potential
	gen D_actual_minus_potential=maGY20-GREgRpot0
	newey D_actual_minus_potential Z* D911 DGR if smpl0==1, lag(4)

	*** test cumulative sum for the actual is zero	
	lincom Z0+Z1+Z2+Z3+Z4+Z5+Z6+Z7+Z8
	local pval_dif_irf=strofreal((1-normal(abs(r(estimate)/r(se))))*2,"%4.3f")

	*** test pointwise that the actual output IRF (growth rate) is zero for the growth rate
	test Z0 Z1 Z2 Z3 Z4 Z5 Z6 Z7 Z8
	local pval_dif_irf_point=strofreal(r(p),"%4.3f") 

	*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	*				   IRF for HP actual output - potential
	*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	
	capture drop D_actual_minus_potential2
	gen D_actual_minus_potential2=hp_dlogY-GREgRpot0
	newey D_actual_minus_potential2 Z* D911 DGR if smpl0==1, lag(4)

	*** test cumulative sum for the actual is zero	
	lincom Z0+Z1+Z2+Z3+Z4+Z5+Z6+Z7+Z8
	local pval_hpdif_irf=strofreal((1-normal(abs(r(estimate)/r(se))))*2,"%4.3f")

	*** test pointwise that the actual output IRF (growth rate) is zero for the growth rate
	test Z0 Z1 Z2 Z3 Z4 Z5 Z6 Z7 Z8
	local pval_hpdif_irf_point=strofreal(r(p),"%4.3f") 
	
	noisily di "p-val equality of IRFs:  (`pval_dif_irf') [`pval_dif_irf_point']"
	noisily di "p-val actual IRF:  (`pval_act_irf') [`pval_act_irf_point']"
	noisily di "p-val potential IRF: (`pval_pot_irf') [`pval_pot_irf_point']"	

	twoway ///
	(rarea irf_act_m_lo irf_act_m_up irf_0 if irf_0<=8, color(gs14)) ///
	(line irf_act_m  irf_0 if irf_0<=8, lcolor(black) lpattern(solid) lwidth(thick)) ///
	(line irf_pot_m  irf_0 if irf_0<=8, lcolor(blue) lpattern(solid)) ///
	(line irf_pot_m_up  irf_0 if irf_0<=8, lcolor(blue) lpattern(dash)) ///
	(line irf_pot_m_lo  irf_0 if irf_0<=8, lcolor(blue) lpattern(dash)) ///
	(scatter irf_hp_m  irf_0 if irf_0<=8, connect(direct) lcolor(red) msymbol(o) msize(3) mcolor(red) mfcolor(white) lpattern(solid)) ///
	(line irf_hp_m_up  irf_0 if irf_0<=8, lcolor(red) lpattern(shortdash)) ///
	(line irf_hp_m_lo  irf_0 if irf_0<=8, lcolor(red) lpattern(shortdash)) ///		
	, ///
	xtitle("") xlabel(0(1)8) ///
	ytitle("output growth rate, percent, annualized") ///
	title("`var_str'") ///
	legend(order(2 1 3 4 6 7 9) ///
	label(1 "`confidencestr' CI") ///
	label(2 "RT Actual (5yr MA), (`pval_act_irf') [`pval_act_irf_point']") ///
	label(3 "Potential Output  , (`pval_pot_irf') [`pval_pot_irf_point']") ///
	label(4 "`confidencestr' CI") ///
	label(6 "RT Actual (HP fi.), (`pval_hp_irf') [`pval_hp_irf_point']") ///
	label(7 "`confidencestr' CI")  ///
	label(9 "HP Actual=Potenti., (`pval_hpdif_irf') [`pval_hpdif_irf_point']") ///
	rows(4)  ring(3) position(7)) ///
	graphregion(color(white)) bgcolor(white) ///				
	name(`var', replace)
						  
}

*========================================================================
*			variables with NO contemporanous response
*========================================================================

quiet foreach var in MPOa MPVAR0 {

	noisily di "====================================================="
	noisily di "			`var'"
	noisily di "====================================================="
	
	if "`var'"=="MPOa" local var_str="Monetary policy shock (Romer and Romer 2004)"
	if "`var'"=="MPVAR0" local var_str="Monetary policy shock (VAR)"
	
	capture drop Z*
	gen Z=`var'
	sum Z
	replace Z=Z/r(sd)
	
	* Create current and lagged values of the shock
	
	forvalues i=1(1)8 {
		gen Z`i'=l`i'.Z
	}
	
	reg GREgRpot0 maGY20 Z?
	capture drop smpl0
	gen smpl0=e(sample)
	drop Z
	
	capture drop irf*
	*** time for IRFs
	gen irf_0=t-1
	
	*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	*				        IRF for potential output
	*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	
	newey GREgRpot0 Z* D911 DGR if smpl0==1, lag(4)
	
	gen irf_pot_m=.
	gen irf_pot_se=.
	local str0="0"
	
	replace irf_pot_m=0 if irf_0==0
	replace irf_pot_se=0 if irf_0==0
		
	forvalues i=1(1)8 {
		local str0="`str0'" + "+Z`i'" 
		lincom "`str0'"
		replace irf_pot_m=r(estimate) if irf_0==`i'
		replace irf_pot_se=r(se) if irf_0==`i'
	}	
	
	gen irf_pot_m_up=irf_pot_m+`confidenceval'*irf_pot_se
	gen irf_pot_m_lo=irf_pot_m-`confidenceval'*irf_pot_se
	
	*** test cumulative sum for the potential is zero
	lincom Z1+Z2+Z3+Z4+Z5+Z6+Z7+Z8
	local pval_pot_irf=strofreal((1-normal(abs(r(estimate)/r(se))))*2,"%4.3f") 
	
	*** test pointwise that the potential output IRF (growth rate) is zero for the growth rate
	test Z1 Z2 Z3 Z4 Z5 Z6 Z7 Z8
	local pval_pot_irf_point=strofreal(r(p),"%4.3f") 

	*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	*				         IRF for actual output
	*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	
	newey maGY20 Z* D911 DGR if smpl0==1, lag(4)

	gen irf_act_m=.
	gen irf_act_se=.	
	local str0="0"
	
	replace irf_act_m=0 if irf_0==0
	replace irf_act_se=0 if irf_0==0
		
	forvalues i=1(1)8 {
		local str0="`str0'" + "+Z`i'" 
		lincom "`str0'"
		replace irf_act_m=r(estimate) if irf_0==`i'
		replace irf_act_se=r(se) if irf_0==`i'
	}		
		
	gen irf_act_m_up=irf_act_m+`confidenceval'*irf_act_se
	gen irf_act_m_lo=irf_act_m-`confidenceval'*irf_act_se		

	*** test cumulative sum for the actual is zero	
	lincom Z1+Z2+Z3+Z4+Z5+Z6+Z7+Z8
	local pval_act_irf=strofreal((1-normal(abs(r(estimate)/r(se))))*2,"%4.3f")

	*** test pointwise that the actual output IRF (growth rate) is zero for the growth rate
	test Z1 Z2 Z3 Z4 Z5 Z6 Z7 Z8
	local pval_act_irf_point=strofreal(r(p),"%4.3f") 

	*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	*				  IRF for HP filtered actual output
	*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	
	newey hp_dlogY Z* D911 DGR if smpl0==1, lag(4)

	gen irf_hp_m=.
	gen irf_hp_se=.	
	local str0="0"
	
	replace irf_hp_m=0 if irf_0==0
	replace irf_hp_se=0 if irf_0==0
		
	forvalues i=1(1)8 {
		local str0="`str0'" + "+Z`i'" 
		lincom "`str0'"
		replace irf_hp_m=r(estimate) if irf_0==`i'
		replace irf_hp_se=r(se) if irf_0==`i'
	}		
		
	gen irf_hp_m_up=irf_hp_m+`confidenceval'*irf_hp_se
	gen irf_hp_m_lo=irf_hp_m-`confidenceval'  *irf_hp_se		

	*** test cumulative sum for the actual is zero	
	lincom Z1+Z2+Z3+Z4+Z5+Z6+Z7+Z8
	local pval_hp_irf=strofreal((1-normal(abs(r(estimate)/r(se))))*2,"%4.3f")

	*** test pointwise that the actual output IRF (growth rate) is zero for the growth rate
	test Z1 Z2 Z3 Z4 Z5 Z6 Z7 Z8
	local pval_hp_irf_point=strofreal(r(p),"%4.3f") 

	*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	*				   IRF for actual output - potential
	*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	
	capture drop D_actual_minus_potential
	gen D_actual_minus_potential=maGY20-GREgRpot0
	newey D_actual_minus_potential Z* D911 DGR if smpl0==1, lag(4)

	*** test cumulative sum for the actual is zero	
	lincom Z1+Z2+Z3+Z4+Z5+Z6+Z7+Z8
	local pval_dif_irf=strofreal((1-normal(abs(r(estimate)/r(se))))*2,"%4.3f")

	*** test pointwise that the actual output IRF (growth rate) is zero for the growth rate
	test Z1 Z2 Z3 Z4 Z5 Z6 Z7 Z8
	local pval_dif_irf_point=strofreal(r(p),"%4.3f") 

	*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	*				 IRF for HP actual output - potential
	*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	
	capture drop D_actual_minus_potential2
	gen D_actual_minus_potential2=hp_dlogY-GREgRpot0
	newey D_actual_minus_potential2 Z* D911 DGR if smpl0==1, lag(4)

	*** test cumulative sum for the actual is zero	
	lincom Z1+Z2+Z3+Z4+Z5+Z6+Z7+Z8
	local pval_hpdif_irf=strofreal((1-normal(abs(r(estimate)/r(se))))*2,"%4.3f")

	*** test pointwise that the actual output IRF (growth rate) is zero for the growth rate
	test Z1 Z2 Z3 Z4 Z5 Z6 Z7 Z8
	local pval_hpdif_irf_point=strofreal(r(p),"%4.3f") 
	
	noisily di "p-val equality of IRFs:  (`pval_dif_irf') [`pval_dif_irf_point']"
	noisily di "p-val actual IRF:  (`pval_act_irf') [`pval_act_irf_point']"
	noisily di "p-val potential IRF: (`pval_pot_irf') [`pval_pot_irf_point']"
	
	twoway ///
	(rarea irf_act_m_lo irf_act_m_up irf_0 if irf_0<=8, color(gs14)) ///
	(line irf_act_m  irf_0 if irf_0<=8, lcolor(black) lpattern(solid) lwidth(thick)) ///
	(line irf_pot_m  irf_0 if irf_0<=8, lcolor(blue) lpattern(solid)) ///
	(line irf_pot_m_up  irf_0 if irf_0<=8, lcolor(blue) lpattern(dash)) ///
	(line irf_pot_m_lo  irf_0 if irf_0<=8, lcolor(blue) lpattern(dash)) ///
	(scatter irf_hp_m  irf_0 if irf_0<=8, connect(direct) lcolor(red) msymbol(o) msize(3) mcolor(red) mfcolor(white) lpattern(solid)) ///
	(line irf_hp_m_up  irf_0 if irf_0<=8, lcolor(red) lpattern(shortdash)) ///
	(line irf_hp_m_lo  irf_0 if irf_0<=8, lcolor(red) lpattern(shortdash)) ///				
	, ///
	xtitle("") xlabel(0(1)8) ///
	ytitle("output growth rate, percent, annualized") ///
	title("`var_str'") ///
	legend(order(2 1 3 4 6 7 9) ///
	label(1 "`confidencestr' CI") ///
	label(2 "RT Actual (5yr MA), (`pval_act_irf') [`pval_act_irf_point']") ///
	label(3 "Potential Output  , (`pval_pot_irf') [`pval_pot_irf_point']") ///
	label(4 "`confidencestr' CI") ///
	label(6 "RT Actual (HP fi.), (`pval_hp_irf') [`pval_hp_irf_point']") ///
	label(7 "`confidencestr' CI")  ///
	label(9 "HP Actual=Potenti., (`pval_hpdif_irf') [`pval_hpdif_irf_point']") ///
	rows(4)  ring(3) position(7)) ///
	graphregion(color(white)) bgcolor(white) ///						
	name(`var', replace)
						  
}

window manage close graph _all
graph combine TFP FP2 OILK, rows(1) ysize(2) graphregion(color(white)) plotregion(color(white)) t1title(Panel A: Supply Shocks) name(panela, replace)
graph combine MPOa DE1 sFP1SPF1, rows(1) ysize(2) graphregion(color(white)) plotregion(color(white)) t1title(Panel B: Demand Shocks) name(panelb, replace)

window manage close graph _all
graph combine panela panelb, rows(2) altshrink graphregion(color(white)) plotregion(color(white))
